﻿/*
VERSION:	1.6

1.5		Revised forEach() to be a strictly local function instead of polluting the global Array object
			(It was conflicting with ZigoEngine)

1.4		Add:  VOW.firstWait() & VOW.wait()
	VOW.firstWait(500)
		.then( func )
		.then( VOW.wait(1000) )
		.then( func )
	
	func()
		.then( VOW.wait(1000) )
		.then( func )
		
1.3		VOW.wait has a default wait of 1 frame AKA 34 milliseconds
1.2		VOW.wait() added to allow setTimeout-style delays, like so:
				VOW.wait( 1000 ).then( doSomething );
1.1		keep() and doBreak() return their promise obj, to allow returning pre-kept promises like so:
				return VOW.make().keep()
				This allows async functions to be optionally be synchronous
				
USAGE:
	#include "functions/VOW.as"
	_global.VOW = VOW;
	function doAsync( input ){
		var vow = VOW.make();
		onSucceed = function(){
			vow.keep( results );
		}
		onFail = function(){
			vow.doBreak( reason );
		}
		return vow.promise;
	}// doAsync()
	
	doAsync("param A").then( useResults )
	
	
	promiseA = doAsync("param A");
	promiseB = doSomethingElse("param B");
	promiseC = doAsync("param C");
	VOW.every([
	 promiseA,
	 promiseB,
	 promiseC
	]).then( laterFunc );
	
	
	
EXPLANATION:
	function doAsync()
		returns a promise and calls promise.keep() later on
	
	promise1.then( onSucceess, onFail );
		When this promise is kept, it calls the 1st function
		If this promise is broken, it calls the 2nd function
	
	VOW.every([ promise1, promise2 ]).then( handleResults );
	
	promise1
		.then( handleResult1, onFail )	// use the result of promise1, then make promise2
		.then( handleResult2, onFail )	// use the result of promise2, then make promise3
		.then( handleResult3, onFail )	// use the result of promise3
	
	
FUNCTIONS
	VOW				Used to create vows & check promises
		make
		every
		any
		first
		
	vow				Used by async functions that make promises
		promise
		keep
		doBreak
	
	promise		Used to call reactions later when some async thing finishes
		is_promise
		then
*/
/*
Array.prototype.forEach = function( callback ){
	for(var i=0; i<this.length; i++){
		callback( this[i], i );
	}// for:  each item within this array
}// Array.forEach()
*/



var vow_scope = function(){
	function forEach( array, callback){
		for(var i=0; i<array.length; i++){
			callback( array[i], i );
		}// for:  each item within this array
	}// forEach()
	
	
	
	function enlighten(queue, fate){
		forEach(queue, function (func) {
			setTimeout(function(){
				func(fate);
			}, 0);// setTimeout()
		});// forEach()
	}// enlighten()
	
	
	return {
		make: function (){
			var breakers = [],
					fate,
					keepers = [], 
					status = 'pending';
			
			
			function enqueue (resolution, func, vow){
				var queue = resolution === 'kept' ? keepers : breakers;
				queue[queue.length] = typeof func !== 'function'
					? vow[resolution]
					: function (value) {
						try {
							var result = func(value);
							if(result && result.is_promise === true){
								result.then( vow.keep, vow.doBreak );
							}// if:  result is a promise
							else
							{// if:  result is NOT a promise
								vow.keep(result);
							}// if:  result is NOT a promise
						}// try
						catch(e){
							vow.doBreak(e);
						}// catch
					}// queue[length] = func
			}// enqueue()
			
			
			function herald (state, value, queue){
				if(status !== 'pending'){
					 throw 'overpromise';		// do not resolve twice
				}// if:  this promise is already resolved
				fate = value;
				status = state;
				enlighten(queue, fate);
				//keepers.length = 0;
				//breakers.length = 0;
				keepers = [];
				breakers = [];
			}// herald()
			
			
			return {
				doBreak: function (value){
					herald('broken', value, breakers);
					return this.promise;
				},// doBreak()
				keep: function (value){
					herald('kept', value, keepers);
					return this.promise;
				},// keep()
				promise: {
					is_promise: true,
					then: function (kept, broken){
						var vow = VOW.make();
						switch (status){
							case 'pending':
								enqueue('kept', kept, vow);
								enqueue('break', broken, vow);
							break;
							case 'kept':
								enqueue('kept', kept, vow);
								enlighten(keepers, fate);
							break;
							case 'broken':
								enqueue('break', broken, vow);
								enlighten(breakers, fate);
							break;
						}// case: status
						return vow.promise;
					}// then()
				}// {promise}
			}// return {break, keep, promise}
		},// make()
		
		
// The every function takes an array of promises and returns a promise that
// will deliver an array of results only if every promise is kept.
// 
// The "every" function returns a promise whose then() gives an array containing
// the result of each promise ONLY if all promises succeeded.
		every: function (array){
			var remaining = array.length,
					results = [],
					vow = VOW.make();
			if(!remaining){
				vow.doBreak(array);
			}// if:  array is empty
			else
			{// if:  array has values
				forEach( array, function (promise, i){
					promise.then(
						function (value) {
							results[i] = value;
							remaining--;
							if(remaining === 0){
								vow.keep(results);
							}// if:  array counter is Zero
						},// success()
						function (reason) {
							remaining = null;
							vow.doBreak(reason);
						}// fail()
					);// then()
				});// array.forEach()
				
			}// if:  array has values
			return vow.promise;
		},// every()
		
		
// The first function takes an array of promises and returns a promise to
// deliver the first observed kept promise, or a broken promise if all of
// the promises are broken.
// 
// The "first" function returns a promise whose then() gives the result 
// of the promise that completes first, ignoring all others.
		first: function (array){
			var found = false,
					remaining = array.length,
					vow = VOW.make();
			function check(){
				remaining--;
				if(remaining === 0  &&  !found){
					vow.doBreak();
				}// if:  no more items to check
			}// check()
			if(remaining === 0){
				vow.doBreak(array);
			}// if:  array was empty to begin with
			else
			{// if:  array has values
				forEach( array, function (promise){
					promise.then(
						function (value){
							if(!found){
								found = true;
								vow.keep(value);
							}//if:  found not updated yet
							check();
						},// success()
						check		// fail()
					);// then()
				});// array.forEach()
			}// if:  array has values
			return vow.promise;
		},// first()
		
		
// The any function takes an array of promises and returns a promise that
// will deliver a possibly sparse array of results of any kept promises.
// The result will contain an undefined element for each broken promise.
// 
// The "any" function returns a promise whose then() gives an array containing
// the results of each promise. Promises that failed have an undefined value as
// their result.
		any: function (array){
			var remaining = array.length,
					results = [],
					vow = VOW.make();
			function check(){
				remaining--;
				if(remaining === 0){
					vow.keep(results);
				}// if:  no more items to check
			}// check()
			if(!remaining){
				vow.keep(results);
			}// if:  array was empty to begin with
			else
			{// if:  array has values
				forEach( array, function (promise, i) {
					promise.then(
						function (value) {
							results[i] = value;
							check();
						},// success()
						check		// fail()
					);// then()
				});// array.forEach()
			}// if:  array has values
			return vow.promise;
		},// any()
		
		
		kept: function (value){
			var vow = VOW.make();
			vow.keep(value);
			return vow.promise;
		},// kept()
		
		
		broken: function (reason){
			var vow = VOW.make();
			vow.doBreak(reason);
			return vow.promise;
		},// broken()
		
		
		wait: function (){
			var doWait = function(milliseconds){
				var vow = VOW.make();
				var milliseconds = milliseconds || 1000;
				setTimeout(function() {
					vow.keep({});
					},
					milliseconds);
				return vow.promise;
			}// doWait()
			return doWait;
		},// wait()
		
		
		firstWait: function (milliseconds){
			var vow = VOW.make();
			var milliseconds = milliseconds || 1000;
			setTimeout(function() {
				vow.keep({});
				},
				milliseconds);
			return vow.promise;
		}// firstWait()
	}// return {}
};// vow_scope()
var VOW = vow_scope();
delete vow_scope;